<?php
session_start(); // ¡ESTA LÍNEA ES LA QUE FALTABA!
require_once 'config.php';

$response = ['success' => false, 'message' => 'No autorizado.']; // Este es el error que estás viendo

// 1. Verificar que el usuario esté logueado
if (!isset($_SESSION['user_id'])) {
    // Como falta session_start(), esta comprobación falla
    header('Content-Type: application/json');
    echo json_encode($response);
    exit();
}

$user_id = $_SESSION['user_id'];

// 2. Verificar que se hayan enviado los datos
if (isset($_FILES['imagenProyecto']) && isset($_POST['nombreProyecto']) && isset($_POST['ancho_cm']) && isset($_POST['alto_cm'])) {
    
    $nombre_proyecto = $_POST['nombreProyecto'];
    $ancho_cm = (float)$_POST['ancho_cm'];
    $alto_cm = (float)$_POST['alto_cm'];
    $filtro = $_POST['filtro'] ?? 'none';
    
    $es_publico = (isset($_POST['es_publico']) && $_POST['es_publico'] == '1') ? 1 : 0;

    $imagen = $_FILES['imagenProyecto'];
    
    if ($imagen['error'] !== UPLOAD_ERR_OK) {
        $response['message'] = 'Error al subir la imagen.';
        header('Content-Type: application/json');
        echo json_encode($response);
        exit();
    }

    $user_upload_dir = 'uploads/user_' . $user_id;
    if (!is_dir($user_upload_dir)) {
        mkdir($user_upload_dir, 0755, true); 
    }

    $extension = strtolower(pathinfo($imagen['name'], PATHINFO_EXTENSION));
    
    if (!in_array($extension, ['jpg', 'jpeg', 'png'])) {
        $response['message'] = 'Error: Solo se permiten archivos JPG, JPEG o PNG.';
        header('Content-Type: application/json');
        echo json_encode($response);
        exit();
    }

    $nombre_archivo_unico = uniqid('proj_') . '.' . $extension;
    $ruta_destino_completa = $user_upload_dir . '/' . $nombre_archivo_unico;
    
    if (move_uploaded_file($imagen['tmp_name'], $ruta_destino_completa)) {
        
        $ruta_miniatura = $ruta_destino_completa;

        try {
            $stmt = $pdo->prepare(
                "INSERT INTO proyectos (user_id, nombre_proyecto, url_imagen, url_miniatura, ancho_cm, alto_cm, filtro, es_publico) 
                 VALUES (?, ?, ?, ?, ?, ?, ?, ?)"
            );
            $stmt->execute([
                $user_id,
                $nombre_proyecto,
                $ruta_destino_completa,
                $ruta_miniatura,
                $ancho_cm,
                $alto_cm,
                $filtro,
                $es_publico
            ]);
            
            $response['success'] = true;
            $response['message'] = '¡Proyecto guardado con éxito!';

        } catch (PDOException $e) {
            $response['message'] = 'Error de base de datos: ' . $e->getMessage();
            unlink($ruta_destino_completa);
        }

    } else {
        $response['message'] = 'Error al mover el archivo. Verifica los permisos de la carpeta.';
    }
} else {
    $response['message'] = 'Faltan datos para guardar el proyecto.';
}

header('Content-Type: application/json');
echo json_encode($response);
exit();
?>