document.addEventListener('DOMContentLoaded', () => {
    const galleryGrid = document.getElementById('gallery-grid');
    const loadingMessage = document.getElementById('gallery-loading-message');

    fetch('cargar_comunidad.php', { cache: 'no-store' })
        .then(response => response.json())
        .then(data => {
            if (data.success && data.proyectos.length > 0) {
                loadingMessage.style.display = 'none'; 
                
                data.proyectos.forEach(proyecto => {
                    const proyectoCard = document.createElement('a');
                    proyectoCard.className = 'proyecto-card';
                    // Al hacer clic, se carga en el editor
                    proyectoCard.href = `poster.html?cargar_id=${proyecto.id}`;
                    
                    proyectoCard.innerHTML = `
                        <img src="${proyecto.url_miniatura}" alt="${proyecto.nombre_proyecto}">
                        <h3>${proyecto.nombre_proyecto}</h3>
                        <p>${proyecto.ancho_cm}cm x ${proyecto.alto_cm}cm</p>
                        <p class="project-author">Por: ${proyecto.creador_nombre}</p>
                    `;
                    galleryGrid.appendChild(proyectoCard);
                });

            } else if (data.success && data.proyectos.length === 0) {
                loadingMessage.textContent = 'Aún no hay proyectos públicos. ¡Sé el primero!';
            } else {
                loadingMessage.textContent = 'Error al cargar los proyectos.';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            loadingMessage.textContent = 'Error de conexión.';
        });
});