<?php
// Este script NO necesita sesión, es público
require_once 'config.php';

$response = ['success' => false, 'proyectos' => []];

try {
    // 1. Preparamos la consulta para buscar proyectos públicos
    // Unimos (JOIN) con la tabla 'usuarios' para obtener el nombre del creador
    $stmt = $pdo->prepare("
        SELECT 
            p.id, 
            p.nombre_proyecto, 
            p.url_miniatura, 
            p.ancho_cm, 
            p.alto_cm,
            u.nombre AS creador_nombre
        FROM proyectos AS p
        JOIN usuarios AS u ON p.user_id = u.id
        WHERE p.es_publico = 1
        ORDER BY p.fecha_creacion DESC
        LIMIT 50
    "); // Limitamos a 50 para que no sea muy pesado
    
    $stmt->execute();
    $proyectos = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $response['success'] = true;
    $response['proyectos'] = $proyectos;

} catch (PDOException $e) {
    $response['message'] = 'Error de base de datos.';
}

header('Content-Type: application/json');
echo json_encode($response);
exit();
?>