document.addEventListener('DOMContentLoaded', () => {
    const userSessionElement = document.getElementById('user-session');
    if (!userSessionElement) return;

    fetch('check_session.php', { cache: 'no-store' })
        .then(response => {
            if (!response.ok) {
                throw new Error(`Error HTTP! estado: ${response.status}`);
            }
            return response.json();
        })
        .then(data => {
            if (data.loggedIn) {
                userSessionElement.innerHTML = `
                    <div class="user-info">
                        Bienvenido, <strong>${data.nombre}</strong>
                        <span>|</span>
                        Créditos: ${data.creditos}
                        <span>|</span>
                        <a href="galeria.html">Mi Galería</a>
                        <span>|</span>
                        <a href="comunidad.html">Galería Pública</a>
                        <span>|</span>
                        <a href="logout.php">Cerrar Sesión</a>
                    </div>
                `;
            } else {
                userSessionElement.innerHTML = `
                    <a href="login.php" class="login-button">Iniciar Sesión con Google</a>
                `;
            }
        })
        .catch(error => {
            console.error('Error al chequear la sesión:', error);
            userSessionElement.innerHTML = '<a href="login.php" class="login-button">Iniciar Sesión (Error)</a>';
        });
});