// --- Lógica de Sesión (Copiada para consistencia) ---

const creditCounter = document.getElementById('creditCounterDisplay');
const userSessionElement = document.getElementById('user-session');

function updateCreditCounter(amount) {
    if (creditCounter) {
        creditCounter.textContent = `Créditos: ${amount}`;
        creditCounter.style.display = 'block';
    }
}

function checkLoginStatus() {
    fetch('check_session.php', { cache: 'no-store' })
        .then(response => {
            if (!response.ok) {
                throw new Error(`Error HTTP! estado: ${response.status}`);
            }
            return response.json();
        })
        .then(data => {
            if (data.loggedIn) {
                userSessionElement.innerHTML = `
                    <div class="user-info">
                        Bienvenido, <strong>${data.nombre}</strong>
                        <span>|</span>
                        <a href="index.html">Inicio</a>
                        <span>|</span>
                        <a href="galeria.html">Mi Galería</a>
                        <span>|</span>
                        <a href="comunidad.html">Galería Pública</a>
                        <span>|</span>
                        <a href="logout.php">Cerrar Sesión</a>
                    </div>
                `;
                updateCreditCounter(data.creditos);
            } else {
                alert('Necesitas iniciar sesión para usar esta herramienta.');
                window.location.href = 'index.html';
            }
        })
        .catch(error => {
            console.error('Error al chequear la sesión:', error);
            alert('Error de conexión o de sesión. Redirigiendo al inicio.');
            window.location.href = 'index.html';
        });
}

// --- Lógica de la Herramienta de Letras ---

const textInput = document.getElementById('textInput');
const fontSelector = document.getElementById('fontSelector');
const previewArea = document.getElementById('previewArea');
const styleFillBtn = document.getElementById('styleFillBtn');
const styleOutlineBtn = document.getElementById('styleOutlineBtn');
const downloadBtn = document.getElementById('downloadBtn');
const formatSelector = document.getElementById('formatSelector');
const statusDiv = document.getElementById('status');

let currentStyle = 'fill';
let currentFont = 'Anton'; // Valor inicial que coincide con el HTML
let currentText = '¡Escribe algo!'; // Valor inicial

function updatePreview() {
    // 1. Obtener valores
    currentText = textInput.value;
    currentFont = fontSelector.value;
    
    // 2. Actualizar previsualización
    previewArea.textContent = currentText;
    previewArea.style.fontFamily = `'${currentFont}', sans-serif`;

    // 3. Aplicar estilo (Relleno o Contorno)
    if (currentStyle === 'outline') {
        previewArea.classList.add('text-outline');
    } else {
        previewArea.classList.remove('text-outline');
    }
}

// 
// ¡ESTA ES LA PARTE QUE NO TE FUNCIONABA!
// Conecta el campo de texto a la función de previsualización.
//
textInput.addEventListener('input', updatePreview);
fontSelector.addEventListener('input', updatePreview);

styleFillBtn.addEventListener('click', () => {
    currentStyle = 'fill';
    styleFillBtn.classList.add('active');
    styleOutlineBtn.classList.remove('active');
    updatePreview();
});

styleOutlineBtn.addEventListener('click', () => {
    currentStyle = 'outline';
    styleOutlineBtn.classList.add('active');
    styleFillBtn.classList.remove('active');
    updatePreview();
});

// --- LÓGICA DE DESCARGA ---

// Función auxiliar para simular la descarga
function triggerDownload(href, filename) {
    const link = document.createElement('a');
    link.href = href;
    link.download = filename;
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
}

// 1. Lógica de descarga de SVG
function downloadAsSVG() {
    const svgNS = "http://www.w3.org/2000/svg";
    const svg = document.createElementNS(svgNS, "svg");
    const textElement = document.createElementNS(svgNS, "text");
    
    textElement.setAttributeNS(null, "x", "50%");
    textElement.setAttributeNS(null, "y", "50%");
    textElement.setAttributeNS(null, "dominant-baseline", "middle");
    textElement.setAttributeNS(null, "text-anchor", "middle");
    textElement.setAttributeNS(null, "font-family", `'${currentFont}', sans-serif`);
    textElement.setAttributeNS(null, "font-size", "100px");
    textElement.textContent = currentText;

    if (currentStyle === 'outline') {
        textElement.setAttributeNS(null, "fill", "none");
        textElement.setAttributeNS(null, "stroke", "black");
        textElement.setAttributeNS(null, "stroke-width", "2px");
    } else {
        textElement.setAttributeNS(null, "fill", "black");
    }
    
    svg.appendChild(textElement);
    
    // Medir el texto para un viewBox preciso
    const tempSpan = document.createElement('span');
    tempSpan.style.fontFamily = `'${currentFont}', sans-serif`;
    tempSpan.style.fontSize = "100px";
    tempSpan.style.visibility = "hidden";
    tempSpan.style.position = "absolute";
    tempSpan.textContent = currentText;
    document.body.appendChild(tempSpan);
    const width = tempSpan.offsetWidth + 20; // 20px padding
    const height = tempSpan.offsetHeight + 20; // 20px padding
    document.body.removeChild(tempSpan);

    svg.setAttribute("viewBox", `0 0 ${width} ${height}`);
    textElement.setAttributeNS(null, "x", "50%"); 
    textElement.setAttributeNS(null, "y", "50%");

    const svgData = new XMLSerializer().serializeToString(svg);
    const dataUrl = 'data:image/svg+xml;charset=utf-8,' + encodeURIComponent(svgData);

    triggerDownload(dataUrl, 'molde_texto_espacioapp.svg');
}

// 2. Nueva lógica de descarga de Imagen (PNG/JPG)
function downloadAsImage(format) {
    const elementToCapture = document.getElementById('previewArea');
    statusDiv.textContent = "Generando imagen... por favor espera.";
    
    // Truco para que el contorno PNG tenga fondo transparente
    if (format === 'png' && currentStyle === 'outline') {
        elementToCapture.classList.add('html2canvas-outline-png');
    }

    html2canvas(elementToCapture, {
        backgroundColor: null, // Captura con fondo transparente
        scale: 2 // Aumenta la resolución (2x)
    }).then(canvas => {
        
        // Quitar el truco
        elementToCapture.classList.remove('html2canvas-outline-png');

        let dataUrl;
        let filename;

        if (format === 'jpg') {
            // Para JPG, necesitamos crear un canvas nuevo y ponerle fondo blanco
            const jpgCanvas = document.createElement('canvas');
            jpgCanvas.width = canvas.width;
            jpgCanvas.height = canvas.height;
            const ctx = jpgCanvas.getContext('2d');
            
            ctx.fillStyle = '#FFFFFF'; // Fondo blanco
            ctx.fillRect(0, 0, jpgCanvas.width, jpgCanvas.height);
            ctx.drawImage(canvas, 0, 0); // Dibujar la captura encima

            dataUrl = jpgCanvas.toDataURL('image/jpeg', 0.9); // Calidad 90%
            filename = 'molde_texto_espacioapp.jpg';
        } else {
            // Para PNG, es directo
            dataUrl = canvas.toDataURL('image/png');
            filename = 'molde_texto_espacioapp.png';
        }
        
        triggerDownload(dataUrl, filename);
        statusDiv.textContent = "Escribe tu texto, elige una fuente y un estilo.";

    }).catch(err => {
        console.error("Error con html2canvas:", err);
        statusDiv.textContent = "Error al generar la imagen.";
        elementToCapture.classList.remove('html2canvas-outline-png');
    });
}

// Listener del Botón Principal de Descarga
downloadBtn.addEventListener('click', () => {
    const format = formatSelector.value;

    if (format === 'svg') {
        downloadAsSVG();
    } else {
        downloadAsImage(format);
    }
});

// --- INICIALIZACIÓN ---
checkLoginStatus(); // Revisa la sesión
updatePreview(); // Actualiza la previsualización al cargar