<?php
session_start(); // ¡NUEVO! Iniciar sesión aquí
require_once 'config.php';

// 1. Verificar si Google nos dio un código
if (!isset($_GET['code'])) {
    die("Error: No se recibió código de Google.");
}

$code = $_GET['code'];

// 2. Intercambiar el código por un Token de Acceso
$tokenUrl = 'https://oauth2.googleapis.com/token';
$tokenParams = [
    'code' => $code,
    'client_id' => GOOGLE_CLIENT_ID,
    'client_secret' => GOOGLE_CLIENT_SECRET,
    'redirect_uri' => GOOGLE_REDIRECT_URL,
    'grant_type' => 'authorization_code'
];

$ch = curl_init($tokenUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($tokenParams));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

$tokenData = json_decode($response, true);

if (!isset($tokenData['access_token'])) {
    die("Error: No se pudo obtener el token de acceso de Google.");
}

$accessToken = $tokenData['access_token'];

// 3. Usar el Token para obtener la información del usuario
$userInfoUrl = 'https://www.googleapis.com/oauth2/v2/userinfo';
$ch = curl_init($userInfoUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Authorization: Bearer ' . $accessToken]);
$userInfoResponse = curl_exec($ch);
curl_close($ch);

$userInfo = json_decode($userInfoResponse, true);

if (!isset($userInfo['id']) || !isset($userInfo['email'])) {
    die("Error: No se pudo obtener la información del usuario.");
}

$google_id = $userInfo['id'];
$email = $userInfo['email'];
$nombre = $userInfo['name'] ?? 'Usuario';

try {
    // 4. Buscar al usuario en la Base de Datos
    $stmt = $pdo->prepare("SELECT * FROM usuarios WHERE google_id = ?");
    $stmt->execute([$google_id]);
    $usuario = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($usuario) {
        // 5. El usuario YA EXISTE. Iniciar sesión.
        $_SESSION['user_id'] = $usuario['id'];
        $_SESSION['user_nombre'] = $usuario['nombre'];
        $_SESSION['user_email'] = $usuario['email'];
    } else {
        // 6. El usuario es NUEVO. Crearlo.
        $stmt = $pdo->prepare(
            "INSERT INTO usuarios (google_id, email, nombre, creditos) VALUES (?, ?, ?, ?)"
        );
        $stmt->execute([
            $google_id, 
            $email, 
            $nombre, 
            CREDITOS_INICIALES 
        ]);
        
        $newUserId = $pdo->lastInsertId();

        // Iniciar sesión
        $_SESSION['user_id'] = $newUserId;
        $_SESSION['user_nombre'] = $nombre;
        $_SESSION['user_email'] = $email;
    }

    // 7. Redirigir al usuario de vuelta a la herramienta de pósters
    header('Location: poster.html');
    exit();

} catch (PDOException $e) {
    die("Error de base de datos: " . $e->getMessage());
}
?>