// --- Lógica de Sesión ---
const creditCounter = document.getElementById('creditCounterDisplay');
const userSessionElement = document.getElementById('user-session');

function updateCreditCounter(amount) {
    if (creditCounter) { creditCounter.textContent = `Créditos: ${amount}`; creditCounter.style.display = 'block'; }
}
function checkLoginStatus() {
    fetch('check_session.php', { cache: 'no-store' })
        .then(r => r.json()).then(d => {
            if (d.loggedIn) {
                userSessionElement.innerHTML = `Hola, <strong>${d.nombre}</strong> | <a href="index.html">Inicio</a> | <a href="logout.php">Salir</a>`;
                updateCreditCounter(d.creditos);
            } else { alert('Inicia sesión'); window.location.href = 'index.html'; }
        }).catch(e => console.error(e));
}
checkLoginStatus();

document.addEventListener('DOMContentLoaded', () => {
    const canvas = document.getElementById('textCanvas');
    const ctx = canvas.getContext('2d');

    // Inputs
    const textInput = document.getElementById('textInput');
    const fontSelector = document.getElementById('fontSelector');
    const oneCharPerSheet = document.getElementById('oneCharPerSheet');
    const mirrorMode = document.getElementById('mirrorMode');
    const fillColorInput = document.getElementById('fillColor');
    const strokeWidthInput = document.getElementById('strokeWidth');
    const strokeColorInput = document.getElementById('strokeColor');
    const patternBtns = document.querySelectorAll('.pattern-btn');
    const downloadBtn = document.getElementById('downloadBtn');
    const posterBtn = document.getElementById('posterBtn');
    const statusDiv = document.getElementById('status');

    let activePattern = 'solid';

    // Configuración Canvas (Alta resolución interna)
    canvas.width = 1200; 
    canvas.height = 600;

    // --- GENERADOR DE PATRONES ---
    function createPattern(type, color) {
        const pCvs = document.createElement('canvas');
        const pCtx = pCvs.getContext('2d');
        const s = 100; // Tamaño del patrón
        pCvs.width = s; pCvs.height = s;
        
        // Fondo transparente
        pCtx.clearRect(0,0,s,s);
        pCtx.fillStyle = color;

        if (type === 'dots') { 
            pCtx.beginPath(); pCtx.arc(25,25,10,0,Math.PI*2); pCtx.arc(75,75,10,0,Math.PI*2); pCtx.fill(); 
        }
        else if (type === 'stripes') { pCtx.fillRect(0,0,25,100); pCtx.fillRect(50,0,25,100); }
        else if (type === 'checkers') { pCtx.fillRect(0,0,50,50); pCtx.fillRect(50,50,50,50); }
        else if (type === 'hearts') { drawShape(pCtx, 'heart', color); }
        else if (type === 'stars') { drawShape(pCtx, 'star', color); }
        else if (type === 'cow') { drawShape(pCtx, 'cow', color); }
        
        return ctx.createPattern(pCvs, 'repeat');
    }

    function drawShape(ctx, shape, color) {
        ctx.fillStyle = color;
        if(shape==='heart'){
            ctx.beginPath(); ctx.moveTo(50,30); ctx.bezierCurveTo(50,25,40,0,20,0); ctx.bezierCurveTo(0,0,0,35,0,35); ctx.bezierCurveTo(0,55,40,77,50,90); ctx.bezierCurveTo(60,77,100,55,100,35); ctx.bezierCurveTo(100,35,100,0,80,0); ctx.bezierCurveTo(60,0,50,25,50,30); ctx.fill();
        } else if(shape==='star'){
            ctx.save(); ctx.translate(50,50); ctx.beginPath();
            for(let i=0; i<5; i++){ ctx.lineTo(Math.cos((18+i*72)/180*Math.PI)*40, -Math.sin((18+i*72)/180*Math.PI)*40); ctx.lineTo(Math.cos((54+i*72)/180*Math.PI)*20, -Math.sin((54+i*72)/180*Math.PI)*20); }
            ctx.closePath(); ctx.fill(); ctx.restore();
        } else if(shape==='cow'){
            ctx.beginPath(); ctx.arc(30,30,20,0,7); ctx.arc(80,70,25,0,7); ctx.fill();
        }
    }

    // --- DIBUJAR EN CANVAS ---
    function draw() {
        const text = textInput.value || " ";
        const font = fontSelector.value;
        const isMirror = mirrorMode.checked;
        const isOneChar = oneCharPerSheet.checked;
        const sWidth = parseInt(strokeWidthInput.value);

        ctx.clearRect(0, 0, canvas.width, canvas.height);
        
        ctx.save();
        
        // Configurar Fuente
        // Si es una letra por hoja, usamos un tamaño enorme para el preview
        let fontSize = isOneChar ? 400 : 150;
        if (!isOneChar && text.length > 10) fontSize = 80;
        
        ctx.font = `bold ${fontSize}px "${font}"`;
        ctx.textBaseline = "middle";
        ctx.textAlign = "center";

        // Aplicar Espejo
        if (isMirror) {
            ctx.translate(canvas.width, 0);
            ctx.scale(-1, 1);
        }

        // ¿Qué dibujamos? Si es modo "Una letra por hoja", en el preview mostramos solo la primera letra
        // para que se vea bien el detalle.
        const textToDraw = isOneChar ? text.charAt(0).toUpperCase() : text;
        const cx = canvas.width / 2;
        const cy = canvas.height / 2;

        // 1. Relleno
        if (activePattern === 'outline') {
            ctx.fillStyle = "transparent"; // No pintar nada dentro
        } else if (activePattern === 'solid') {
            ctx.fillStyle = fillColorInput.value;
        } else {
            ctx.fillStyle = createPattern(activePattern, fillColorInput.value);
        }
        
        if (activePattern !== 'outline') ctx.fillText(textToDraw, cx, cy);

        // 2. Borde
        if (sWidth > 0 || activePattern === 'outline') {
            ctx.strokeStyle = strokeColorInput.value;
            ctx.lineWidth = sWidth || 2;
            ctx.strokeText(textToDraw, cx, cy);
        }

        ctx.restore();

        // Mensaje de estado
        statusDiv.textContent = isOneChar 
            ? `Modo Guirnalda: Se generará un PDF de ${text.length} páginas (una letra por hoja).` 
            : "Modo Estándar: Todo el texto en una sola hoja.";
    }

    // --- LISTENERS ---
    const inputs = [textInput, fontSelector, oneCharPerSheet, mirrorMode, fillColorInput, strokeWidthInput, strokeColorInput];
    inputs.forEach(el => el.addEventListener('input', draw));

    patternBtns.forEach(btn => {
        btn.addEventListener('click', (e) => {
            patternBtns.forEach(b => b.classList.remove('active'));
            e.currentTarget.classList.add('active');
            activePattern = e.currentTarget.dataset.pattern;
            draw();
        });
    });

    // --- GENERAR PDF ---
    downloadBtn.addEventListener('click', () => {
        const { jsPDF } = window.jspdf;
        // A4 Horizontal
        const doc = new jsPDF({ orientation: 'l', unit: 'mm', format: 'a4' });
        const text = textInput.value.trim();
        const isOneChar = oneCharPerSheet.checked;

        if (!text) return;

        if (isOneChar) {
            // MODO GUIRNALDA (1 Letra por Hoja)
            for (let i = 0; i < text.length; i++) {
                if (i > 0) doc.addPage();
                
                // Limpiamos el canvas y dibujamos SOLAMENTE la letra actual
                ctx.clearRect(0,0,canvas.width,canvas.height);
                ctx.save();
                
                if (mirrorMode.checked) { ctx.translate(canvas.width, 0); ctx.scale(-1, 1); }
                
                ctx.font = `bold 450px "${fontSelector.value}"`; // Tamaño máximo
                ctx.textAlign = "center"; ctx.textBaseline = "middle";
                
                const char = text[i];
                const cx = canvas.width / 2;
                const cy = canvas.height / 2;

                // Relleno
                if (activePattern === 'outline') ctx.fillStyle = "transparent";
                else if (activePattern === 'solid') ctx.fillStyle = fillColorInput.value;
                else ctx.fillStyle = createPattern(activePattern, fillColorInput.value);
                
                if(activePattern!=='outline') ctx.fillText(char, cx, cy);
                
                // Borde
                const sWidth = parseInt(strokeWidthInput.value);
                if (sWidth > 0 || activePattern === 'outline') {
                    ctx.strokeStyle = strokeColorInput.value;
                    ctx.lineWidth = sWidth * 2; 
                    ctx.strokeText(char, cx, cy);
                }
                ctx.restore();

                // Convertir a imagen y poner en PDF
                const imgData = canvas.toDataURL('image/png');
                doc.addImage(imgData, 'PNG', 10, 10, 277, 190); // Llenar la hoja A4
                doc.setFontSize(10);
                doc.text(`Letra ${i+1}/${text.length} - espacioapp.site`, 280, 200, {align:'right'});
            }
            // Restaurar vista previa original
            draw(); 

        } else {
            // MODO ESTÁNDAR (Todo en una hoja)
            const imgData = canvas.toDataURL('image/png');
            doc.addImage(imgData, 'PNG', 10, 50, 277, 110);
            doc.text("Molde de Texto - espacioapp.site", 10, 200);
        }

        doc.save(`Letras_${text}.pdf`);
    });

    // --- ENVIAR A PÓSTER GIGANTE ---
    posterBtn.addEventListener('click', () => {
        // Para el póster, enviamos lo que se ve en el canvas actualmente
        const dataUrl = canvas.toDataURL('image/png');
        sessionStorage.setItem('temp_poster_image', dataUrl);
        sessionStorage.setItem('temp_poster_name', 'Letrero_' + textInput.value);
        window.location.href = 'poster.html?action=load_temp';
    });

    // Iniciar
    draw();
});