<?php
session_start();
require_once 'config.php';

$response = ['success' => false, 'proyectos' => []];

if (!isset($_SESSION['user_id'])) {
    header('Content-Type: application/json');
    echo json_encode($response);
    exit();
}

try {
    $stmt = $pdo->prepare("SELECT id, nombre_proyecto, url_miniatura, ancho_cm, alto_cm 
                           FROM proyectos 
                           WHERE user_id = ? 
                           ORDER BY fecha_creacion DESC");
    $stmt->execute([$_SESSION['user_id']]);
    $proyectos = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $response['success'] = true;
    $response['proyectos'] = $proyectos;

} catch (PDOException $e) {
    // No hacer nada, se devolverá success: false
}

header('Content-Type: application/json');
echo json_encode($response);
exit();
?>